//
//  NSString+Additions.h
//  PushNotification
//
//  Created by Oleksii Dykan on 4/15/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 Additional method for NSString
 */
@interface NSString (Additions)

/**
 Generate string push notification token from NSData
 
 @param deviceToken Push notification device token
 */
+ (NSString *)tokenStringFromData:(NSData *)deviceToken;

/**
 Create body string for NSURLRequest separated by &
 
 @param body Dictionary to generate body string from
 */
+ (NSString *)bodyStringFromDictionary:(NSDictionary *)body;

/**
 Create md5 hash string from NSArray
 
 @warning All components must of type NSString
 
 @param components Components to generate md5 has string from
 */
+ (NSString *)md5HashFromComponents:(NSArray *)components;

/**
 Get current mac serial number
 */
+ (NSString *)macSerial;

/**
 Create json string from dictionary
 
 @param jsonDict JSON Dictionary
 */
+ (NSString *)jsonStringFromDictionary:(NSDictionary *)jsonDict;

/**
 Create json string from array
 
 @param jsonArray JSON Array
 */
+ (NSString *)jsonStringFromArray:(NSArray *)jsonArray;

/**
 Create md5 hash from string
 */
- (NSString *)md5;

/**
 percent encode string for NSURLConnection
 */
- (NSString *)urlEncode;

/**
 Percent encode special characters
 */
- (NSString *)stringByPercentEncodingSpecialCharacters;

/**
 UUID string
 */
+ (NSString*)stringWithUUID;

@end
